<?php echo $__env->make($activeTemplate . 'partials.headers', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="content-body">
    <div class="container-fluid">
        <div class="row">
            <!-- Code Start -->
            <div class="row">
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-lg-12 order-lg-1">
                                    <h4 class="mb-3">Manage Referrals</h4><br/>
                                    <div class="mb-3">
                                        <label for="address" class="form-label">Referral Link</label>
                                        <input type="text" value="<?php echo e(route('home')); ?>/ref/<?php echo e($user->ref); ?>" class="form-control" id="myInput">
                                    </div>
                                    <hr class="mb-4">
                                    <button class="btn btn-primary btn-lg btn-block" type="button" onclick="myFunction()">Copy My Referral Link</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Referred Users</h4>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-responsive-sm">
                                <thead>
                                    <tr>
                                        <th><?php echo app('translator')->get('Full Name'); ?></th>
                                        <th><?php echo app('translator')->get('User Name'); ?></th>
                                        <th><?php echo app('translator')->get('Email'); ?></th>
                                        <th><?php echo app('translator')->get('Mobile'); ?></th>
                                        <th><?php echo app('translator')->get('Plan'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $refUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td data-label="<?php echo app('translator')->get('Full Name'); ?>"><?php echo e(__($log->fullname)); ?></td>
                                        <td data-label="<?php echo app('translator')->get('User Name'); ?>"><?php echo e(__($log->username)); ?></td>
                                        <td data-label="<?php echo app('translator')->get('Email'); ?>"><?php echo e($log->email); ?></td>
                                        <td data-label="<?php echo app('translator')->get('Phone'); ?>"><?php echo e($log->mobile); ?></td>
                                        <td data-label="<?php echo app('translator')->get('Plan'); ?>"><?php echo e(__($log->plan ? $log->plan->name : "No Plan")); ?></td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="100%" class="text-center"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Code Ends -->
        </div>
    </div>
</div>

<script src="/assets/global/js/jquery-3.6.0.min.js"></script>

<script>
    function copyToClipboard(text) {
        var sampleTextarea = document.createElement("textarea");
        document.body.appendChild(sampleTextarea);
        sampleTextarea.value = text; //save main text in it
        sampleTextarea.select(); //select textarea contents
        document.execCommand("copy");
        document.body.removeChild(sampleTextarea);
    }

    function myFunction() {
        var copyText = document.getElementById("myInput");
        copyToClipboard(copyText.value);

        /* Alert the copied text */
        alert("Copied Link: " + copyText.value);
    }
</script>

<?php echo $__env->make('partials.notify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make($activeTemplate . 'partials.footers', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /home/sites/27a/0/0c7ab12dd1/admin/core/resources/views/templates/basic/user/referred.blade.php ENDPATH**/ ?>