
<?php $__env->startSection('content'); ?>
    <section class="cmn-section price">
        <div class="container">
            <div class="row justify-content-center">
                <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xl-4 col-lg-4 col-md-6 mb-4">
                        <div class="single-price">
                            <div class="part-top">
                                <h3><?php echo e(__($plan->name)); ?></h3>
                                <h4><?php echo e(__(showAmount($plan->price))); ?> <?php echo e($general->cur_text); ?><br></h4>
                            </div>
                            <div class="part-bottom">
                                <ul>
                                    <li><?php echo app('translator')->get('Plan Details'); ?></li>
                                    <li><?php echo app('translator')->get('Daily Limit'); ?> : <?php echo e($plan->daily_limit); ?> <?php echo app('translator')->get('PTC'); ?></li>
                                    <li><?php echo app('translator')->get('Referral Bonus'); ?> : <?php echo app('translator')->get('Upto'); ?> <?php echo e($plan->ref_level); ?> <?php echo app('translator')->get('Level'); ?></li>
                                    <li><?php echo app('translator')->get('Plan Price'); ?> : <?php echo e(showAmount($plan->price)); ?> <?php echo e(__($general->cur_text)); ?></li>
                                    <li><?php echo app('translator')->get('Validity'); ?> : <?php echo e($plan->validity); ?> <?php echo app('translator')->get('Days'); ?></li>
                                </ul>

                                <?php if(@auth()->user()->runningPlan && @auth()->user()->plan_id == $plan->id): ?>
                                    <button class="package-disabled"><?php echo app('translator')->get('Current Package'); ?></button>
                                <?php else: ?>
                                    <button class="buyBtn" data-id="<?php echo e($plan->id); ?>"><?php echo app('translator')->get('Subscribe Now'); ?></button>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>

    <div class="modal fade" id="BuyModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">

                <form method="post" action="<?php echo e(route('user.buyPlan')); ?>">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="id">
                    <div class="modal-header">
                        <strong class="modal-title"> <?php echo app('translator')->get('Confirmation'); ?></strong>

                        <button type="button" class="close btn btn-sm" data-bs-dismiss="modal">&times;</button>
                    </div>
                    <div class="modal-body">
                        <?php if(auth()->guard()->check()): ?>
                        <strong><?php echo app('translator')->get('Are you sure to subscribe this plan'); ?>?</strong>
                            <?php if(auth()->user()->runningPlan): ?>
                            <code class="d-block"><?php echo app('translator')->get('If you subscribe to this one. Your old limitation will reset according to this package.'); ?></code>
                            <?php endif; ?>
                        <?php else: ?>
                        <strong><?php echo app('translator')->get('Please login to subscribe plan'); ?></strong>
                        <?php endif; ?>
                    </div>
                    <div class="modal-footer">
                        <?php if(auth()->guard()->check()): ?>
                            <button type="button" class="btn btn-dark" data-bs-dismiss="modal"><?php echo app('translator')->get('No'); ?></button>
                            <button type="submit" class="btn btn--base"><?php echo app('translator')->get('Yes'); ?></button>
                        <?php else: ?>
                            <a href="<?php echo e(route('user.login')); ?>" class="btn btn--base w-100"><?php echo app('translator')->get('Login'); ?></a>
                        <?php endif; ?>
                    </div>

                </form>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('style'); ?>
    <style>
        .package-disabled {
            opacity: 0.5;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script'); ?>
    <script type="text/javascript">
        (function($) {
            "use strict";
            $('.buyBtn').click(function() {
                var modal = $('#BuyModal');
                modal.find('input[name=id]').val($(this).data('id'));
                modal.modal('show');
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sksdollar/aksd.sksdollar.online/Files/core/resources/views/templates/basic/plans.blade.php ENDPATH**/ ?>