<?php $__env->startSection('panel'); ?>
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-body">
                <form role="form" method="POST" action="<?php echo e(route("admin.ptc.update",$ptc->id)); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                       <div class="form-group col-md-8">
                        <label><?php echo app('translator')->get('Title of the Ad'); ?></label>
                        <input type="text" name="title" class="form-control" value="<?php echo e($ptc->title); ?>" placeholder="<?php echo app('translator')->get('Title'); ?>" required>
                    </div>

                    <div class="form-group col-md-4">
                        <label><?php echo app('translator')->get('Amount'); ?></label>
                        <div class="input-group">
                            <input type="number" step="any" name="amount" class="form-control" value="<?php echo e(getAmount($ptc->amount)); ?>" placeholder="<?php echo app('translator')->get('User will get ...'); ?>" required>
                            <div class="input-group-text"> <?php echo e($general->cur_text); ?> </div>
                        </div>
                    </div>


                    <div class="form-group col-md-4">
                        <label><?php echo app('translator')->get('Duration'); ?></label>
                        <div class="input-group">
                            <input type="number" name="duration" class="form-control" value="<?php echo e($ptc->duration); ?>" placeholder="<?php echo app('translator')->get('Duration'); ?>" required>
                            <div class="input-group-text"><?php echo app('translator')->get('SECONDS'); ?></div>
                        </div>
                    </div>

                    <div class="form-group col-md-4">
                        <label><?php echo app('translator')->get('Maximum Show'); ?></label>
                        <div class="input-group">
                            <input type="number" name="max_show" class="form-control" value="<?php echo e($ptc->max_show); ?>" placeholder="<?php echo app('translator')->get('Maximum Show'); ?> " required>
                            <div class="input-group-text"><?php echo app('translator')->get('Times'); ?></div>
                        </div>
                    </div>

                    <div class="form-group col-md-4">
                        <label><?php echo app('translator')->get('Status'); ?></label>
                        <select class="form-control" name="status" <?php if($ptc->status == 3): echo 'disabled'; endif; ?> required>
                            <option value=""><?php echo app('translator')->get('Select One'); ?></option>
                            <option value="1"><?php echo app('translator')->get('Active / Approve'); ?></option>
                            <option value="2"><?php echo app('translator')->get('Pending / Under Review'); ?></option>
                            <option value="0"><?php echo app('translator')->get('Inactive'); ?></option>
                            <option value="3"><?php echo app('translator')->get('Reject'); ?></option>
                        </select>
                        <?php if($ptc->status == 3): ?> <input type="hidden" name="status" value="3"> <?php endif; ?>
                    </div>
                </div>


                <div class="row pt-5 mt-5 border-top">
                    <div class="form-group col-md-4">
                        <label for="ads_type"><?php echo app('translator')->get('Advertisement Type'); ?></label>
                        <input type="hidden" name="ads_type" value="<?php echo e($ptc->ads_type); ?>">
                        <div class="pt-3">
                            <?php echo $ptc->typeBadge ?>
                        </div>
                    </div>
                    <?php if($ptc->ads_type == 1): ?>

                    <div class="form-group col-md-8">
                        <label><?php echo app('translator')->get('Link'); ?> <span class="text-danger">*</span></label>
                        <input type="text" name="website_link" class="form-control" value="<?php echo e($ptc->ads_body); ?>" placeholder="<?php echo app('translator')->get('http://example.com'); ?>">
                    </div>
                    <?php elseif($ptc->ads_type == 2): ?>

                    <div class="form-group col-md-4 ">
                        <label><?php echo app('translator')->get('Banner'); ?></label>
                        <input type="file" class="form-control"  name="banner_image">
                    </div>

                       <div class="form-group col-md-4 ">

                        <label><?php echo app('translator')->get('Current Banner'); ?> <span class="text-danger">*</span></label>
                        <img src="<?php echo e(getImage(getFilePath('ptc').'/'.$ptc->ads_body)); ?>" class="w-100">

                    </div>

                    <?php elseif($ptc->ads_type == 3): ?>

                    <div class="form-group col-md-8">
                        <label><?php echo app('translator')->get('Script'); ?> <span class="text-danger">*</span></label>
                        <textarea  name="script" class="form-control"><?php echo e($ptc->ads_body); ?></textarea>
                    </div>

                    <?php else: ?>
                        <div class="form-group col-md-8">
                            <label><?php echo app('translator')->get('Youtube Embaded Link'); ?> <span class="text-danger">*</span></label>
                            <input type="text" name="youtube" class="form-control" value="<?php echo e($ptc->ads_body); ?>">
                        </div>
                    <?php endif; ?>
                </div>
                <div class="form-group col-md-12 mt-3">
                    <button type="submit" class="btn btn--primary h-45 w-100"><?php echo app('translator')->get('Submit'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
<a href="<?php echo e(route('admin.ptc.index')); ?>" class="btn btn-outline--primary btn-sm"><i class="las la-undo"></i> <?php echo app('translator')->get('Back'); ?> </a>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('script'); ?>
<script>
    (function($){
        "use strict";
        $('#ads_type').change(function(){
            var adType = $(this).val();
            if (adType == 1) {
                $("#websiteLink").removeClass('d-none');
                $("#bannerImage").addClass('d-none');
                $("#script").addClass('d-none');
                $("#youtube").addClass('d-none');
            } else if (adType == 2) {
                $("#bannerImage").removeClass('d-none');
                $("#websiteLink").addClass('d-none');
                $("#script").addClass('d-none');
                $("#youtube").addClass('d-none');
            } else if(adType == 3) {
                $("#bannerImage").addClass('d-none');
                $("#websiteLink").addClass('d-none');
                $("#script").removeClass('d-none');
                $("#youtube").addClass('d-none');
            } else {
                $("#bannerImage").addClass('d-none');
                $("#websiteLink").addClass('d-none');
                $("#script").addClass('d-none');
                $("#youtube").removeClass('d-none');
            }
        }).change();

        $('[name=status]').val('<?php echo e($ptc->status); ?>');
    })(jQuery);
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u934853891/domains/duple-kast.site/public_html/core/resources/views/admin/ptc/edit.blade.php ENDPATH**/ ?>